import { Link } from "wouter";
import { Input } from "@/components/ui/input";
import { Button } from "@/components/ui/button";
import { Facebook, Twitter, Instagram, Youtube } from "lucide-react";

export default function Footer() {
  return (
    <footer className="bg-dark-card py-10">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          <div>
            <h3 className="text-lg font-semibold text-white mb-4">MovieStream</h3>
            <p className="text-gray-400 text-sm">The best platform for watching translated and non-translated movies from around the world.</p>
          </div>
          
          <div>
            <h3 className="text-lg font-semibold text-white mb-4">Categories</h3>
            <ul className="space-y-2 text-sm text-gray-400">
              <li><Link href="/translated-movies" className="hover:text-white">Translated Movies</Link></li>
              <li><Link href="/non-translated-movies" className="hover:text-white">Non-Translated Movies</Link></li>
              <li><Link href="/?genre=Action" className="hover:text-white">Action</Link></li>
              <li><Link href="/?genre=Comedy" className="hover:text-white">Comedy</Link></li>
              <li><Link href="/?genre=Drama" className="hover:text-white">Drama</Link></li>
            </ul>
          </div>
          
          <div>
            <h3 className="text-lg font-semibold text-white mb-4">Quick Links</h3>
            <ul className="space-y-2 text-sm text-gray-400">
              <li><Link href="/" className="hover:text-white">Home</Link></li>
              <li><Link href="/about" className="hover:text-white">About Us</Link></li>
              <li><Link href="/faq" className="hover:text-white">FAQ</Link></li>
              <li><Link href="/contact" className="hover:text-white">Contact</Link></li>
              <li><Link href="/privacy-policy" className="hover:text-white">Privacy Policy</Link></li>
            </ul>
          </div>
          
          <div>
            <h3 className="text-lg font-semibold text-white mb-4">Connect With Us</h3>
            <div className="flex space-x-4 text-gray-400 text-xl mb-4">
              <a href="#" className="hover:text-white"><Facebook /></a>
              <a href="#" className="hover:text-white"><Twitter /></a>
              <a href="#" className="hover:text-white"><Instagram /></a>
              <a href="#" className="hover:text-white"><Youtube /></a>
            </div>
            <p className="text-sm text-gray-400">Subscribe to our newsletter:</p>
            <div className="mt-2 flex">
              <Input
                type="email"
                placeholder="Your email"
                className="bg-gray-800 px-4 py-2 text-sm text-white rounded-l focus:outline-none focus:ring-1 focus:ring-primary"
              />
              <Button className="bg-primary hover:bg-secondary text-white px-4 py-2 rounded-r text-sm">
                Subscribe
              </Button>
            </div>
          </div>
        </div>
        
        <div className="border-t border-gray-800 mt-10 pt-6 text-center text-sm text-gray-400">
          <p>&copy; {new Date().getFullYear()} MovieStream. All rights reserved.</p>
        </div>
      </div>
    </footer>
  );
}
