import { useState } from "react";
import { Button } from "@/components/ui/button";

interface GenreFilterProps {
  genres: string[];
  onFilterChange: (genre: string) => void;
}

export default function GenreFilter({ genres, onFilterChange }: GenreFilterProps) {
  const [activeGenre, setActiveGenre] = useState<string>("All");

  const handleGenreClick = (genre: string) => {
    setActiveGenre(genre);
    onFilterChange(genre === "All" ? "" : genre);
  };

  return (
    <div className="flex flex-wrap gap-2 mb-6">
      <Button
        onClick={() => handleGenreClick("All")}
        className={`px-4 py-2 rounded-full text-sm font-medium ${
          activeGenre === "All"
            ? "bg-primary hover:bg-secondary text-white"
            : "bg-dark-card hover:bg-gray-700 text-white"
        }`}
      >
        All
      </Button>
      
      {genres.map((genre) => (
        <Button
          key={genre}
          onClick={() => handleGenreClick(genre)}
          className={`px-4 py-2 rounded-full text-sm font-medium ${
            activeGenre === genre
              ? "bg-primary hover:bg-secondary text-white"
              : "bg-dark-card hover:bg-gray-700 text-white"
          }`}
        >
          {genre}
        </Button>
      ))}
    </div>
  );
}
