import { Link } from "wouter";
import { Button } from "@/components/ui/button";
import { Movie } from "@shared/schema";
import { PlayCircle, Info } from "lucide-react";

interface HeroSectionProps {
  movie: Movie;
}

export default function HeroSection({ movie }: HeroSectionProps) {
  return (
    <div className="relative">
      <div className="w-full h-[60vh] bg-gradient-to-r from-black to-transparent absolute z-10"></div>
      <img 
        src={movie.posterUrl} 
        className="w-full h-[60vh] object-cover" 
        alt={`${movie.title} banner`} 
      />
      <div className="absolute z-20 bottom-0 left-0 p-8 md:p-16">
        <h1 className="text-4xl md:text-6xl font-bold text-white mb-4">{movie.title}</h1>
        <p className="text-lg md:text-xl text-gray-200 mb-6 max-w-2xl">
          {movie.description.length > 200 
            ? `${movie.description.substring(0, 200)}...` 
            : movie.description}
        </p>
        <div className="flex space-x-4">
          <Link href={`/movies/${movie.id}`}>
            <Button className="bg-primary hover:bg-secondary text-white font-bold py-3 px-6 rounded-lg flex items-center">
              <PlayCircle className="mr-2 h-5 w-5" /> Play Now
            </Button>
          </Link>
          <Link href={`/movies/${movie.id}`}>
            <Button variant="secondary" className="bg-gray-800 hover:bg-gray-700 text-white font-bold py-3 px-6 rounded-lg flex items-center">
              <Info className="mr-2 h-5 w-5" /> More Info
            </Button>
          </Link>
        </div>
      </div>
    </div>
  );
}
